<?php
/**
 * Post metaboxes configuration
 *
 * @package  gmaakeup.
 */

add_filter( 'rwmb_meta_boxes', 'gmaakeupzc_register_meta_boxes' );
function gmaakeupzc_register_meta_boxes( $meta_boxes ) {
    $prefix = 'gmaakeupzc_';
	$meta_boxes[] = array(
        'id'         => 'Quote',
        'title'      => esc_html__( 'Post Quote', 'gmaakeup' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Quote', 'gmaakeup' ),
                'desc'  => esc_html__( 'Quote Text Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_quote',
                 'type'    => 'textarea',
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'Link',
        'title'      => esc_html__( 'Post Link', 'gmaakeup' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Link', 'gmaakeup' ),
                'desc'  => esc_html__( 'Link Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_link',
                 'type'    => 'text',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'blog-sections',
        'title'      => esc_html__( 'Post Gallery', 'gmaakeup' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(
            array(
                'name'  => esc_html__( 'Gallery', 'gmaakeup' ),
                'desc'  => '',
                'id'    => $prefix . 'post_gallery',
                'type'             => 'image_advanced',

				// Delete file from Media Library when remove it from post meta?
				// Note: it might affect other posts if you use same file for multiple posts
				'force_delete'     => false,

				// Maximum file uploads.
				'max_file_uploads' => 10,

				// Do not show how many files uploaded/remaining.
				'max_status'       => 'false',

				// Image size that displays in the edit page.
				'image_size'       => 'thumbnail',
            ),
			
        )
    );
	$meta_boxes[] = array(
        'id'         => 'video-sections',
        'title'      => esc_html__( 'Post Video', 'gmaakeup' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Video', 'gmaakeup' ),
                'desc'  => esc_html__( 'Youtube & Viemo Url Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_video',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'audio-sections',
        'title'      => esc_html__( 'Post Audio', 'gmaakeup' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Audio', 'gmaakeup' ),
                'desc'  => esc_html__( 'Soundcloud Embed Ifram Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_audio',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	


      $meta_boxes[] = array(
        'id'         => 'Banner',
        'title'      => esc_html__( 'Banner Img', 'gmaakeup' ),
        'post_types' => 'portfolio',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Banner Img', 'gmaakeup' ),
                'desc'  => esc_html__( 'Banner Img Text Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_banner',
                 'type'    => 'image_advanced',
            ),
        )
    );
	
	$meta_boxes[] = array(
        'id'         => 'team-postions-sections',
        'title'      => esc_html__( 'Team Post', 'gmaakeup' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Post', 'gmaakeup' ),
                'desc'  => esc_html__( 'Text Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_team_postions',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-sections',
        'title'      => esc_html__( 'Team Social Icons', 'gmaakeup' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Social', 'gmaakeup' ),
                'desc'  => esc_html__( 'Text Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-single-sections',
        'title'      => esc_html__( 'Team Social Single Icons', 'gmaakeup' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Social', 'gmaakeup' ),
                'desc'  => esc_html__( 'Text Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_single_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'service-icon-single-sections',
        'title'      => esc_html__( 'Team Social Single Icons', 'gmaakeup' ),
        'post_types' => 'service',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Service Icon', 'gmaakeup' ),
                'desc'  => esc_html__( 'Text Add Here', 'gmaakeup' ),
                'id'    => $prefix . 'post_single_sicon',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
   
    // Add more meta boxes if you want
    // $meta_boxes[] = ...

    return $meta_boxes;
}