<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_Blog extends Widget_Base {

	public function get_name() {
		return 'Elementor-Widget-Blog';
	}

	public function get_title() {
		return esc_html__( 'Zc > Blog Feed', 'gmaakeup' );
	}

	public function get_icon() {
		return 'eicon-posts-masonry';
	}

	protected function _register_controls() {
		$traits = new \gmaakeup_Elementor_Traits($this);

		$this->start_controls_section(
			'blog_controller',
			['label' => esc_html__( 'Blog Feed', 'gmaakeup' ),]
		);
		
        
           $this->add_control(

			'sub_heading',
			[
				'label' => esc_html__( 'Sub Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]
			);
			
        
        $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]
			);
			
            $this->add_control(

			'button_text',
			[
				'label' => esc_html__( 'Button Text' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]
			);
			
            $this->add_control(

			'button_url',
			[
				'label' => esc_html__( 'Button Url' ,'gmaakeup'),
				'type' => Controls_Manager::URL,
			]
			);
        
		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'gmaakeup' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);

		$this->add_control(
			'select_categories',
			[
				'label' => esc_html__( 'Filter by Categories', 'gmaakeup' ),
				'type' => Controls_Manager::SELECT2,
				'options' => gmaakeup_el()->get_terms_dropdown_array([
					'taxonomy' => 'category',
					'hide_empty' => false,
					]),
				'multiple' => true,
			]
		);

		$this->add_control(
			'select_posts',
			[
				'label' => esc_html__( 'Filter by Post.', 'gmaakeup' ),
				'type' => Controls_Manager::SELECT2,
				'options' => gmaakeup_el()->get_posts_dropdown_array([
					'post_type' => 'post',
					'posts_per_page' => -1,
					]),
				'multiple' => true,
			]
		);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {
        
		gmaakeup_el()->get_section('blog', [
			
		
			'sub_heading' => $this->get_settings('sub_heading'),
            'text_heading' => $this->get_settings('text_heading'),
            'button_text' => $this->get_settings('button_text'),
            'button_url' => $this->get_settings('button_url'),
            'brk-img' => $this->get_settings('brk-img'),
			'img' => $this->get_settings('img'),
			'menu-id01' => $this->get_settings('menu-id'),
			'posts_per_page' => $this->get_settings('posts_per_page'),
			'category' => $this->get_settings('select_categories'),
			'include' => $this->get_settings('select_posts'),
          
             'desc' => $this->get_settings('desc'),
			'paged' => ( get_query_var('paged') ) ? get_query_var('paged') : 1,
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_Blog() );
