<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_contacts extends Widget_Base {

	public function get_name() {

		return 'Elementor_contacts-widget';

	}

	public function get_title() {

		return esc_html__( 'Zc > Contact Sections','gmaakeup');

	}

	public function get_icon() {		

		 return 'eicon-image-box';

	 }

	protected function _register_controls() {

		$traits = new \gmaakeup_Elementor_Traits($this);   


		$this->start_controls_section(

			'the_header_controls',

			['label' => esc_html__( 'Contact Section','gmaakeup'),]

		);
          $this->add_control(

			'fmap',

			[
				'label' => esc_html__( 'Map' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]

			); 
        
        $this->add_control(

			'sub_heading',

			[
				'label' => esc_html__( 'Sub Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]

			); 
        
         $this->add_control(

			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]

			);  
        
        $this->add_control(

			'shortcode',

			[
				'label' => esc_html__( 'Enter your shortcode' ,'gmaakeup'),
				'type' => Controls_Manager::TEXTAREA,
			]

			);
        

		$this->end_controls_section();

	}

	protected function render( $instance = [] ) {

        gmaakeup_el()->get_section('contact-sections', [
            
            'fmap' => $this->get_settings('fmap'),
            'text_heading' => $this->get_settings('text_heading'),
            'sub_heading' => $this->get_settings('sub_heading'),
        	'shortcode' => $this->get_settings('shortcode'),
            
			]);

	}

	protected function content_template() {}
    
	public function render_plain_content() {}

}
Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_contacts() );