<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_header_slider extends Widget_Base {

	public function get_name() {
		return 'Elementor-Widget-header-slider';
	}

	public function get_title() {
		return esc_html__( 'Zc > Header Slider', 'gmaakeup' );
	}

	public function get_icon() {
		return 'eicon-slider-device';
	}

	protected function _register_controls() {
		$traits = new \gmaakeup_Elementor_Traits($this);
		
		$this->start_controls_section(
			'the_header_slider_section',
			['label' => esc_html__( ' header-Slider','gmaakeup' ),]
		);
        


		$this->add_control(
			'header-slider-text',
			[
				'label' => esc_html__( 'header Slider','gmaakeup' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					
                    
                    [
						'name' => 'back-image',
						'label' => esc_html__( 'Background Image' ,'gmaakeup' ),
						'type' => Controls_Manager::MEDIA,
					],
                    [
						'name' => 'sub-heading',
						'label' => esc_html__( 'Sub Heading' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],	
                    
                    [
						'name' => 'text-heading',
						'label' => esc_html__( 'Text Heading' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],	
									
					[
						'name' => 'textblog',
						'label' => esc_html__( 'Content' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXTAREA,
					],
					[
						'name' => 'button-text',
						'label' => esc_html__( 'Button Text1' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'button-link',
						'label' => esc_html__( 'Button URL' ,'gmaakeup' ),
						'type' => Controls_Manager::URL,
					],
                    
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		gmaakeup_el()->get_section('header-slider', [
			'header-slider-text1' => $this->get_settings('header-slider-text'),
			'image_animation_section' => $this->get_settings('image_animation'),
			'slide_time_section' => $this->get_settings('slide_time'),
			'phone-number' => $this->get_settings('phone-number'),
			'phone-icon' => $this->get_settings('phone-icon'),
			'slider-line' => $this->get_settings('slider-line'),
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_header_slider() );