<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_service_one_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-service-one-widget';
	}

	public function get_title() {
		return __( 'Zc >  Service One Box' ,'gmaakeup' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \gmaakeup_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Service One Section','gmaakeup'),]
		);
        
        
		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'gmaakeup' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
			]
		);
        
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		gmaakeup_el()->get_section('service-one', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
			'posts_per_page' => $this->get_settings('posts_per_page'),

			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_service_one_box() );